create or replace view OOBJ_CTE_ENVIO as 
select
    -- Informações básicas e sem repetições de um CT-e. Se relaciona com as demais views/tabelas
     1            as id_cte,              -- Chave primária da tabela
	 
	 -- ide - Identificação do CT-e
	 33            as cUF,                 -- Código da UF do emitente do Documento Fiscal
	 null            as cCT,                 -- Código Numérico que compõe a Chave de Acesso
	 6932            as CFOP,                -- Código Fiscal de Operações e Prestações
	 null            as natOp,               -- Natureza da Operação
	 57            as mod,                 -- Modelo do documento fiscal
	 501            as serie,               -- Série do CT-e
	 231            as nCT,                 -- Número do CT-e
	 '2017-10-13 15:52:43'::timestamp            as dhEmi,               -- Data e hora de emissão do CT-e
	 1            as tpImp,               -- Formato de Impressão do DANFE
	 1            as tpEmis,              -- Forma de Emissão da NF-e
	 null            as cDV,                 -- Dígito Verificador da Chave de Acesso da NF-e
	 2            as tpAmb,               -- Identificação do Ambiente
	 0            as tpCTe,               -- Tipo do CT-e
	 3304557            as cMunEnv,             -- Código do Município onde o CT-e está sendo enviado
	 'Rio de Janeiro'            as xMunEnv,             -- Nome do Município onde o CT-e está sendo  enviado
	 'RJ'            as UFEnv,               -- Sigla da UF onde o CT-e está sendo  enviado
	 1            as modal,               -- Modal
	 3            as tpServ,              -- Tipo do Serviço
	 2307650            as cMunIni,             -- Código do Município de início da prestação
	 'MARACANAU'            as xMunIni,             -- Nome do Município do início da prestação
	 'CE'            as UFIni,               -- UF do início da prestação
	 1508050            as cMunFim,             -- Código do Município de término da prestação
	 'TRAIRAO'            as xMunFim,             -- Nome do Município do término da prestação
	 'PA'            as UFFim,               -- UF do término da prestação
	 1            as retira,              -- Indicador se o Recebedor retira no Aeroporto, Filial, Porto ou Estação de Destino.
	 null            as xDetRetira,          -- Detalhes do retira	 
	 null			 as indGlobalizacao,
	 1			 as indIEToma, 
		
	 
	 
	 -- ide > toma - Informações sobre o tomador do serviço
	 0            as toma,                -- Indicador do "papel" do tomador do serviço no CT-e
	 null            as tomaCPFCNPJ,         -- Número do CNPJ
	 null            as tomaIE,              -- Inscrição Estadual
	 null            as tomaXNome,           -- Razão Social ou Nome
	 null            as tomaXFant,           -- Nome Fantasia
	 null            as tomaFone,            -- Telefone
	 null            as tomaXLgr,            -- Logradouro
	 null            as tomaNro,             -- Número
	 null            as tomaXCpl,            -- Complemento
	 null            as tomaXBairro,         -- Bairro
	 null            as tomaCMun,            -- Código do município
	 null            as tomaXMun,            -- Nome do município
	 null            as tomaCEP,             -- Código do CEP
	 null            as tomaUF,              -- Sigla da UF
	 null            as tomaCPais,           -- Código do País
	 null            as tomaXPais,           -- Nome do País
	 null            as tomaEmail,           -- Endereço de e-mail do tomador de serviço
	 -- ide > Informações de Contingência
	 null            as dhCont,              -- Data de entrada em contingência
	 null            as xJust,               -- Justificativa de entrada em contingência

	 -- emailCopia - Informações para envio automático por e-mail de XML e DACTE
	 'teste-sustentacao@oobj.com.br'            as listaEmails,         -- Lista de e-mails destinatários
	 1            as enviarDacteEmail,    -- Informação de envio de PDF DACTE
	 
	 -- compl - Dados complementares do CT-e
	 'CaracAdicTransp'            as complXCaracAd,       -- Característica adicional do transporte
	 'CaracAdicServ'            as complXCaracSer,      -- Característica adicional do serviço
	 'FuncEmissorCTe'            as complXEmi,           -- Funcionário emissor do CTe

	 -- compl > fluxo - Previsão do fluxo da Carga. Obrigatório para modal Aéreo.
	 'SGL_PRT_RGM'            as complFluxXOrig,      -- Sigla ou código interno da Filial/Porto/Estação/Aeroporto de Origem
	 'xPass'            as complFluxPass,       -- Sigla ou código interno da Filial/Porto/Estação/Aeroporto de Passagem
	 'SGL_PRT_DST'            as complFluxXDest,      -- Sigla ou código interno da Filial/Porto/Estação/Aeroporto de Destino
	 'COD_ENTR'            as complFluxXRota,      -- Código da Rota de Entrega

	 -- compl > Entrega - Informações referentes a previsão de entrega.
	 null            as complEntTpPer,       -- Tipo de data/período programado para entrega
	 null            as complEntDProg,       -- Data programada
	 null            as complEntDIni,        -- Data inicial
	 null            as complEntDFim,        -- Data final
	 null            as complEntTpHor,       -- Tipo de hora programado para entrega
	 null            as complEntHProg,       -- Hora programada
	 null            as complEntHIni,        -- Hora inicial
	 null            as complEntHFim,        -- Hora final
	 null            as complOrigCalc,       -- Município de origem para efeito de cálculo do frete
	 null            as complDestCalc,       -- Município de destino para efeito de cálculo do frete

	 'Observações Gerais'            as complXObs,           -- Observações Gerais
	 
	 -- emit - Identificação do Emitente do CT-e
	 '43171438000498'            as emitCNPJ,            -- CNPJ do emitente
	 '81855129'            as emitIE,              -- IE
	 'A.N.R. TRANSPORTES RODOVIARIOS LTDA'            as emitXNome,           -- Razão Social ou nome do emitente
	 'A.N.R. TRANSPORTES RODOVIARIOS LTDA'            as emitXFant,           -- Nome fantasia
	 'AV. PARQUE OESTE, AREA DA GERDAU, BOX 3'            as emitXLgr,            -- Logradouro
	 '0'            as emitNro,             -- Número
	 null            as emitXCpl,            -- Complemento
	 'DISTR.IND.MARACANAA'            as emitXBairro,         -- Bairro
	 3304557            as emitCMun,            -- Código do município
	 'Rio de Janeiro'            as emitXMun,            -- Nome do município
	 '61900000'            as emitCEP,             -- CEP
	 'RJ'            as emitUF,              -- Sigla da UF
	 '08532971422'            as emitFone,            -- Telefone
	 
	 -- rem - Informações do Remetente das Mercadorias
	 '07358761001300'            as remCNPJ,            -- CNPJ do remetente
	 null            as remCPF,             -- CPF do remetente
	 '068447035'            as remIE,              -- Inscrição Estadual
	 'GERDAU (MR) ACOS LONGOS S/A'            as remXNome,           -- Razão social ou nome do remetente
	 'GERDAU (MR) ACOS LONGOS S/A'            as remXFant,           -- Nome fantasia
	 null            as remFone,            -- Telefone
	 null            as remEmail,           -- Endereço de e-mail remetente da carga
	 'AVENIDA PARQUE OESTE'            as remXLgr,            -- Logradouro
	 '1400'            as remNro,             -- Número
	 null            as remXCpl,            -- Complemento
	 'DISTRITO INDUSTRIAL'            as remXBairro,         -- Bairro
	 2307650            as remCMun,            -- Código do município
	 'MARACANAU'            as remXMun,            -- Nome do município
	 '61939120'            as remCEP,             -- CEP
	 'CE'            as remUF,              -- Sigla da UF
	 1058            as remCPais,           -- Código do País
	 'BRASIL'            as remXPais,           -- Nome do País
	 
	 -- locColeta - Informações do local da coleta
	 null            as remLocColetaCNPJ,   -- CNPJ do local da coleta
	 null            as remLocColetaCPF,    -- CPF do local da coleta
	 null            as remLocColetaXNome,  -- Razão social ou nome do local da coleta
	 null            as remLocColetaXLgr,   -- Logradouro do local da coleta
	 null            as remLocColetaNro,    -- Número do local da coleta
	 null            as remLocColetaXCpl,   -- Complemento do local da coleta
	 null            as remLocColetaXBairro,-- Bairro do local da coleta
	 null            as remLocColetaCMun,   -- Código do munícipio do local da coleta
	 null            as remLocColetaXMun,   -- Munícpio do local da coleta
	 null            as remLocColetaUF,     -- UF do local da coleta

	 -- exped - Informações do Expedidor da Carga
	 '11216331000180'            as expedCNPJ,          -- CNPJ do expedidor
	 null            as expedCPF,           -- CPF do expedidor
	 '78909439'            as expedIE,            -- Inscrição Estadual
	 'CDPC - CENTRO DE DIST. PROD DE COBRE LTD'            as expedXNome,         -- Razão social ou nome do expedidor
	 null            as expedFone,          -- Telefone
	 null            as expedEmail,         -- Endereço de e-mail do expedidor da carga
	 'ROD PRESIDENTE DUTRA KM 316, LADO IMPAR'            as expedXLgr,          -- Logradouro
	 'SN'            as expedNro,           -- Número
	 null            as expedXCpl,          -- Complemento
	 'CENTRO'            as expedXBairro,       -- Bairro
	 3302254            as expedCMun,          -- Código do município
	 'ITATIAIA'            as expedXMun,          -- Nome do município
	 '27580000'            as expedCEP,           -- CEP
	 'RJ'            as expedUF,            -- Sigla da UF
	 1058            as expedCPais,         -- Código do País
	 'BRASIL'            as expedXPais,         -- Nome do País
	 
	 -- receb - Informações do Recebedor da Carga
	 null            as recebCNPJ,          -- CNPJ do recebedor
	 null            as recebCPF,           -- CPF do recebedor
	 null            as recebIE,            -- Inscrição Estadual
	 null            as recebXNome,         -- Razão social ou nome do recebedor
	 null            as recebFone,          -- Telefone
	 null            as recebEmail,         -- Endereço de e-mail do recebedor da carga
	 null            as recebXLgr,          -- Logradouro
	 null            as recebNro,           -- Número
	 null            as recebXCpl,          -- Complemento
	 null            as recebXBairro,       -- Bairro
	 null            as recebCMun,          -- Código do município
	 null            as recebXMun,          -- Nome do município
	 null            as recebCEP,           -- CEP
	 null            as recebUF,            -- Sigla da UF
	 null            as recebCPais,         -- Código do País
	 null            as recebXPais,         -- Nome do País
	 
	 -- dest - Informações do Destinatário da Carga
	 '75911438000988'            as destCNPJ,           -- CNPJ do destinatário
	 null            as destCPF,            -- CPF do destinatário
	 '153287179'            as destIE,             -- Inscrição Estadual
	 'ARTELESTE CONSTRUCOES LTDA'            as destXNome,          -- Razão social ou Destinatário
	 '04133822044'            as destFone,           -- Telefone
	 null            as destISUF,           -- Inscrição na SUFRAMA
	 null            as destEmail,          -- Endereço de e-mail do Destinatário
	 'RUA BRASILIA'            as destXLgr,           -- Logradouro
	 'S/N'            as destNro,            -- Número
	 null            as destXCpl,           -- Complemento
	 'CARACOL'            as destXBairro,        -- Bairro
	 1508050            as destCMun,           -- Código do município
	 'TRAIRAO'            as destXMun,           -- Nome do município
	 '68198000'            as destCEP,            -- CEP
	 'PA'            as destUF,             -- Sigla da UF
	 1058            as destCPais,          -- Código do País
	 'BRASIL'            as destXPais,          -- Nome do País
	 
	 -- locEnt - Local de Entrega constante na Nota Fiscal
	 null            as destLocEntCNPJ,     -- CNPJ do local de entrega
	 null            as destLocEntCPF,      -- CPF do local de entrega
	 null            as destLocEntXNome,    -- Razão social ou nome
	 null            as destLocEntXLgr,     -- Logradouro
	 null            as destLocEntNro,      -- Número
	 null            as destLocEntXCpl,     -- Complemento
	 null            as destLocEntXBairro,  -- Bairro
	 null            as destLocEntCMun,     -- Código do município
	 null            as destLocEntXMun,     -- Nome do município
	 null            as destLocEntUF,       -- Sigla da UF
	 
	 -- vPrest - Valores da Prestação de Serviço
	 1136.30            as vPrestVTPrest,      -- Valor Total da Prestação do Serviço
	 1136.30            as vPrestVRec,         -- Valor a Receber
	 
	 -- imp - Informações relativas aos impostos
	 0            as impCST,             -- Classificação tributária do serviço
	 1136.36            as impVBC,             -- Valor da BC do ICMS
	 null            as impVBCSTRet,        -- Valor da BC do ICMS ST Retido
	 null            as impVBCOutraUF,      -- Valor da BC do ICMSOutraUF
	 13.00            as impPICMS,           -- Alíquota do ICMS
	 null            as impPICMSSTRet,      -- Alíquota do ICMS ST Retido
	 null            as impPICMSOutraUF,    -- Alíquota do ICMSOutraUF
	 147.72            as impVICMS,           -- Valor do ICMS
	 null            as impVICMSSTRet,      -- Valor do ICMS ST Retido
	 null            as impVICMSOutraUF,    -- Valor do ICMSOutraUF
	 null            as impPRedBC,          -- Percentual de redução da BC
	 null            as impPRedBCOutraUF,   -- Percentual de redução da BC do ICMSOutraUF
	 null            as impVCred,           -- Valor do Crédito outorgado/Presumido
	 null            as impIndSN,           -- Indica se o contribuinte é Simples Nacional
	 null            as impVTotTrib,        -- Valor Total dos Tributos (NT 2013-001)
	 null            as impInfAdFisco,      -- Informações adicionais de interesse do Fisco
	 
	 -- autXml - Autorizados para download do XML do DF-e
	 '07385111000102;09553244000176'            as autXml,              -- Lista com os CNPJ's e/ou CPF's autorizados para download do XML do DF-e

	-- ICMSUFFim - Partilha de ICMS com UF Destino
	null		 as impvBCUFFim,	-- Valor da BC do ICMS na UF de término da prestação do serviço de transporte
	null		 as imppFCPUFFim,	-- Percentual do ICMS relativo ao Fundo de Combate à pobreza (FCP) na UF de término da prestação do serviço de transporte
	null		 as imppICMSUFFim,	-- Aliquota interna da UF de término da prestação do serviço de transporte
	null		 as imppICMSInter,	-- Alíquota interestadual das UF envolvidas
	null		 as imppICMSInterPart,	-- Percentual da partilha para a UF de término da prestação do serviço de transporte
	null		 as impvFCPUFFim,	-- Valor do ICMS relativo ao Fundo de Combate á Pobreza (FCP) da UF de término da prestação
	null		 as impvIMSUFFim,	-- Valor do ICMS de partilha para a UF de término da prestação do serviço de Transporte
	null		 as impvICMSUFIni	-- Valor do ICMS de partilha para a UF de início da prestação do serviço de Transporte
	
	-- CAMPOS DA REFORMA TRIBUTARIA - NT 2025.001 v1.10
	null         as CST, -- Código de Situação Tributária do IBS/CBS
	null         as cClassTrib, -- Código de Classificação Tributária do IBS/CBS
	null         as indDoacao, -- Informar quando doação
	null         as vBC, -- Valor da base de cálculo comum a IBS/CBS
	null         as pIBSUF, -- Alíquota do IBS da UF
	null         as pDifIBSUF, -- Percentual de diferimento - IBS UF
	null         as vDifIBSUF, -- Valor do diferimento - IBS UF
	null         as vDevTribIBSUF, -- Valor do tributo devolvido - IBS UF
	null         as pRedAliqIBSUF, -- Percentual de redução de alíquota - IBS UF
	null         as pAliqEfetIBSUF, -- Alíquota efetiva - IBS UF
	null         as vIBSUF, -- Valor do IBS da UF
	null         as pIBSMun, -- Alíquota do IBS Municipal
	null         as pDifIBSMun, -- Percentual de diferimento - IBS Município
	null         as vDifIBSMun, -- Valor do diferimento - IBS Município
	null         as vDevTribIBSMun, -- Valor do tributo devolvido do grupo gDevTrib 
	null         as pRedAliqIBSMun, -- Percentual de redução de alíquota - IBS Município
	null         as pAliqEfetIBSMun, -- Alíquota efetiva - IBS Município
	null         as vIBSMun, -- Valor do IBS do Município
	null         as vIBS, -- Valor do IBS (soma de vIBSUF e vIBSMun)
	null         as pCBS, -- Alíquota da CBS
	null         as pDifCBS, -- Percentual de diferimento - CBS
	null         as vDifCBS, -- Valor do diferimento - CBS
	null         as vDevTribCBS, -- Valor do tributo devolvido - CBS
	null         as pRedAliqCBS, -- Percentual de redução de alíquota - CBS
	null         as pAliqEfetCBS, -- Alíquota efetiva - CBS
	null         as vCBS, -- Valor da CBS
	null         as CSTReg, -- Código da Situação Tributária regular
	null         as cClassTribReg, -- Código de Classificação Tributária regular
	null         as pAliqEfetRegIBSUF, -- Alíquota efetiva da UF (regular)
	null         as vTribRegIBSUF, -- Valor do tributo da UF (regular)
	null         as pAliqEfetRegIBSMun, -- Alíquota efetiva do Município (regular)
	null         as vTribRegIBSMun, -- Valor do tributo do Município (regular)
	null         as pAliqEfetRegCBS, -- Alíquota efetiva da CBS (regular)
	null         as vTribRegCBS, -- Valor do tributo CBS (regular)
	null         as pAliqIBSUF, -- Alíquota IBS da UF utilizada
	null         as vTribBSUF, -- Valor do Tributo do IBS da UF Valor que seria devido a UF sem aplicação do Art. 473. da LC 214/20025
	null         as pAliqIBSMun, -- Alíquota IBS do Município utilizada
	null         as vTribIBSMun, -- Valor do Tributo do Município da UF Valor que seria devido ao Município sem aplicação do Art. 473. da LC 214/20025
	null         as pAliqCBS, -- Alíquota IBS do CBS utilizada
	null         as vTribCBS, -- Valor do Tributo da CBS Valor que seria devido a CBS sem aplicação do Art. 473. da LC 214/20025
	null         as vIBSEstCred, -- Valor do IBS a ser estornado
	null         as vCBSEstCred, -- Valor do CBS a ser estornado
	null         as tpEnteGov, -- Tipo de Ente
	null         as pRedutor, -- Percentual de redução de alíquota em compra governamental
	null         as vTotDFe -- Valor total do documento fiscal eletrônico

	
--from <tabela> tab,
-- Condição para o extrator Oobj-CTe ler o registro.
--where <condition> 
